META
key;value
description;District PB in Warszawa, Wesoła
country;Poland
unit;Warszawa
district;Wesoła
subunit;Wesoła
instance;2024
num_projects;32
num_votes;1009
budget;1014271
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
404;75500;527;Książki dla Biblioteki Publicznej w Wesołej;education,culture;children,seniors;1;52.2484302;21.2238718
361;200000;516;Ukwiecona Wesoła;education,public transit and roads,public space,urban greenery;children,seniors;1;52.250924;21.22653324837352
521;25000;482;Zakup 650 e-audiobooków do Biblioteki w Wesołej.;culture;children,seniors;1;52.2484302;21.2238718
205;35500;481;Biblioteczne e-booki. Wypożyczaj nie wychodząc z domu!;education,culture;children,seniors;1;52.2484302;21.2238718
600;6211;424;Zakup do Biblioteki materiałów plastyczno-biurowych na zajęcia z dziećmi.;education,culture;children;1;;
788;202757;392;200 lat Traktu Brzeskiego. Ładniej, czyściej, więcej zieleni i ozdobnych roślin wzdłuż traktu.;education,public transit and roads,culture,environmental protection,public space,urban greenery;children,seniors;1;52.223304170884596;21.23233437538147
579;50000;374;Chronimy i poznajemy nietoperze oraz wiewiórki w lasach Dzielnicy Wesoła – rozwieszenie skrzynek dla odpoczynku i/lub rozrodu tych zwierząt.;environmental protection;;1;;
668;89706;369;Bezpieczna Dzielnica 2024 - Samoobrona , Ratownictwo i Szkoła Bezpiecznego Upadania;education,welfare,public space,sport;children,seniors;1;52.217165300000005;21.23997154206858
862;202800;365;Najstarszy plac zabaw nad kanałkiem w Starej Miłośnie w nowej odsłonie;public space,sport;children,seniors;1;52.21926981025139;21.223483085632328
955;202788;342;Doprowadzenie ul. Jana Pawła II do pięknej alei miejskiej - wizytówki dzielnicy Wesoła - poprawne posadowienie słupów oświetlenia ulicy;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.216336954707074;21.232839420594722
953;202841;340;Doprowadzenie ul. Jana Pawła II do pięknej alei miejskiej - wizytówki dzielnicy Wesoła - rozpłytowanie i urządzenie zieleni w pasie drogowym ul. Jana Pawła II na Osiedlu Stara Miłosna w dzielnicy Wesoła;public transit and roads,environmental protection,public space,urban greenery;children;0;52.21625807429511;21.23206673090697
520;8000;331;Pomoc dla kotów wolno żyjących w Wesołej.;environmental protection;;1;;
625;26000;328;Szkoła Leśna - zajęcia terenowe dla wszystkich: survival, gry i zabawy.;education,environmental protection,sport,urban greenery;children,seniors;1;52.2242430334105;21.2161304072845
1339;75000;318;Kolorowe jarmarki w Starej Miłośnie;education,welfare,public space;children,seniors;1;52.21859813411497;21.234641075134277
615;25800;300;Rolki i nartorolki na Rolkostradzie;education,sport;children;0;52.246856241642;21.21565289315
905;138744;298;Stoły do ping-ponga przy Szkole Podstawowej nr.171 im. Stanisława Staszica;public space,sport;children;0;52.250924;21.22653324837352
899;46000;283;Radosne aktywności dla ciała i ducha: pilates i zajęcia ruchowo-taneczne;culture,sport;seniors;0;;
842;202800;282;Nowoczesna nawierzchnia dla placu zabaw nad kanałkiem w Starej Miłośnie;education,public space;children,seniors;0;52.21880847048681;21.222882270812992
1640;8000;282;Przegląd i renowacja czterech domków dla owadów i przygotowane plakatu o ich mieszkańcach;education,environmental protection;children,seniors;1;52.21452529981359;21.235703229904175
1536;85598;278;odKupmy Kanałek Wawerski;education,public transit and roads,culture,environmental protection,public space,urban greenery;children,seniors;0;52.21848424692538;21.232899045221618
413;13400;272;Nauka jazdy na łyżwach dla dzieci i dorosłych z instruktorem.;public space,sport;children,seniors;0;;
623;19960;245;Siatkówka, MTB, Bieganie - zajęcia z instruktorami sportu;education,sport;seniors;0;52.227615799999995;21.225767656076073
430;200000;244;Modernizacja ulicy Fabrycznej.;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;;
783;7500;226;Drzewa dobrem Wesołej – bądźmy z nimi na ty. Imiona pierwszych nazwanych dębów na drewnianej tablicy w przestrzeni osiedla Stara Miłosna;education,public transit and roads,culture,environmental protection,public space,urban greenery;children,seniors;1;52.2119516;21.2386793
629;27500;223;Zajęcia z orientacji sportowej dla wszystkich;education,environmental protection,sport;children,seniors;0;;
870;42600;220;Ćwiczenie jogi i oddechu dla zdrowia i poczucia dobrostanu;sport;seniors;0;52.21909768137163;21.234855651855472
611;9950;215;Biegówki - zajęcia z instruktorem, wypożyczenie sprzętu i wykład;education,welfare,sport;children,seniors;0;52.232778716049836;21.22652568636649
540;28000;193;Oko w oko z pisarzem - spotkania autorskie dla dzieci i młodzieży;education,culture;children;0;52.23479270000001;21.217821010160275
624;11500;192;Spacery socjalizacyjne z psami - Psi projekt;education,environmental protection,welfare,urban greenery;seniors;0;52.23175487206438;21.223485599005752
416;10000;151;Nasz Nowosielski-pocztówki i kalendarz.;culture;children,seniors;0;;
414;12000;137;Dzienniczek sprawnego seniora - ćw. na każdy dzień.;welfare;seniors;0;;
415;13000;117;Dzielnicowa Olimpiada Seniorów.;sport;seniors;0;;
VOTES
voter_id;vote;age;sex
158;862,870,953,899,416,414,404,1339,521,600,413,361,205,955,905;35;F
159;579,611,668,788,520,955,205,953,623,361,1536,1339,404,615,905;38;F
310;629,600,783,415,414,1640,361,624,788,520,623,905,205,521,404;35;M
331;520,623,430,1339,668;21;M
841;540,899,416,1640,579,955,430,842,788,862,953,668,1536,205,905;37;F
1087;623,404,521,1640,205,905;57;F
1114;540,625,623,615,404,870,899,521,600,416,668,413,205,611,579;42;F
1196;870,625,615,899,521,668,413,205,611;34;F
1436;905,430,788,862,953;52;M
1632;579,521,668,1640,205,783,623,430,520,625,788,953,1339,1536,955;39;F
1636;404,1339,624,413,905;47;F
1740;1640,615,430,520,788,361,953,1339,416,1536,205,611,783,955,579;29;F
1754;404,520,600,955,579,953,1339,1536,413,361,905;33;M
1828;520,1339,361,1640,579,404,521,540,600,205;58;M
1882;623,842,625,862,1339,1536,413;43;M
2092;862,1640,579,415,414,953,783,955,361,624,1536,416,788,540,520;25;M
2185;629,205,1640,905,783,611,625,404,623,413,615,520,899,870,361;38;F
2220;862,1536,413,905,579,955,624,842,788,953,361,1640,783;41;F
2576;415,783,1536,624,899,1339,953,862,788,625,842,430,520,955,905;45;F
2686;404,520,1339,205,579;34;F
2716;1339,430,842,788,953,1536,361,1640,205,955,579,905;24;M
2824;953,788,404,430,611,615,955;47;M
2844;905,579,1640,668,899,623,615,404,625,1339,521,629,600,413,205;37;F
2911;842,862,624,905,415,579,1640,668,416,629,404,521,600,205,414;41;F
2932;1339,361;20;F
2962;404,520,625,788,870,1339,899,629,600,668,361,1640,205,579;38;F
3161;520,953,788;28;M
3234;416,361,1536,955,579,1339,899,1640,624,404,520,540,521,600,205;47;F
3369;625,870,668,955,600,953,404,1339,624,905,788,430,842,862,1536;31;F
3551;520,625,862,1339,600,413,579;42;F
3586;624,1536;32;F
3974;611,955,615,430,404,540,788,953,1339,629,361,579,521,413,205;31;F
4224;668,361,905;34;F
4280;623,899,629,668,361,905;45;F
4309;361,905;40;F
4348;361,905;43;F
4373;361,905;49;F
4400;520,842,404,615,430,788,862,413,361,205;6;F
4409;862,788,540,520,623,430,615,404,842,899,521,600,205,361,905;42;F
4440;862,870,1339,899,521,668,1640,361,205,579,905;29;F
4470;404,788,521,600;37;M
4479;520,668,905;34;F
4656;615,404,625,540,521,361,205,579,905;39;M
4763;416,361,404,520,540,521,600,205,783;56;F
4811;623,625,870,1339,1536,415,842,862,361;42;F
4861;415,668,870,404,615,623,625,540,899,521,629,600,413,361,205;42;F
4919;842,430,404,862,788,899,600,1640,955,579,361,1339,953,870,520;36;F
5050;623,615,404,540,521,205,600,413,361,905;44;F
5085;413,611,414,623,404,842,625,540,862,629,600,416,668,205,905;42;F
5122;615,404,520,600,361,1640,579,905;38;M
5261;361,905;51;F
5367;404,540,521,600,1536,413,955,905;21;M
5520;615,955,579,668,413,1640,629,430,404,842,862,870,953,1339,899;30;F
5635;404,870,1339,899,521,668;32;F
5737;788,623,520,953,1339,899,600,416,615,404,842,862,1536,413,955;38;F
5753;1536,905;31;M
5887;404,520,540,521,600,413,361,205,905;39;F
5935;624,540,521,520,600,783,205,414,615,404,625,668,413,361,905;38;F
6108;623,615,404,870,953,1339,899,668,611,415;50;F
6188;899,615,404,953,1339,521,668,624,955,579,905,870,361,783,520;16;F
6381;611,1640,1339,870,625,899,361,905;57;F
6433;430,625,540,788,953,1339,600,416,668,842,862,870,1536,783;46;F
6481;953,899,624,1536,361,579,520,870,1339,205,783;37;F
6575;862,788,520,404,623,625,540,1339,899,629,668,579,413,361,905;41;F
6685;430,953,1640,955,579,615,404,520,625,1339,521,600,413,361,905;31;F
6796;615,520,788,629,361,415,623,953,1339,416,1640,783,579;43;M
6814;520,788,1339,416,1640,955,430,404,953,899,521,668,205,579,414;63;F
7013;623,624,1536,413,205,611,955,415,953;40;F
7317;404;49;M
7330;615,404,625,870,899,521,629,600,416,413,361,1640,205,611,579;35;F
7544;430,600,955;38;M
7619;414,430,625,862,1339,416,205,579,905,404,520,521,600,668,1640;41;M
7644;788,862,870,1339,521,600,668,1536,1640,579;36;F
7701;404,788,862,870,953,520,625,1339,899,413,361,783,955,579,414;49;F
7743;404,842,579,905,615;40;F
7782;623,404,611,205,361,629,862,842,625,600;39;F
7933;615,1339,361,611,955;47;F
8076;623,404,625,788,862,899,521,416,414,415,842,629,668,361,905;36;F
8097;430,625,540,788,862,953,624,361,611,955,905;40;F
8613;668;50;M
9311;1640,668,899,870,540,430,623,615,625,788,1536,413,611,955;27;F
9446;623,615,625,629,611;34;F
9764;842,615,899,205,955,788,1339,521,600,579,416,413,1640,361,905;52;F
9766;899,953,623,430,842,625,788,862,1339,600,1536,413,361,783,955;36;F
9821;953,1339,361,955,905,430;48;M
9942;579,205,361,1536,600,520,540,788,862,521,783;47;F
9966;430,842,862,521,783,905,413,623,615,629,1640,611,579;54;M
10167;623,615,625,899,629,413,611;45;F
10286;615,862,870,953,899,668,1536,205;29;F
10323;623,615,520,625,862,629,611,1536;36;F
10327;404,842,862,953,521,1640,783,955,579;35;M
10427;783,415,600,629,953,788,540,625,520,842,862,1339,1536,1640,579;37;M
10519;905,361;21;F
10561;430,520,953,1536,955;53;M
10957;623,788,953,899,668,1640,905,415,579,611,361,1536,600,615,520;31;F
10971;953,1536,361,955;36;F
11034;414,955,611,413,624,668,629,521,953,842,430,615,520,862,361;29;F
11208;955,788,611,579,842,615,623,625,862,870,1339,899,629,668,624;45;F
11350;623,615,625,629,611,414;42;F
11638;668,623,615,413,361,205,955,905;40;F
11714;404,521,416,205,361,414,905;70;F
11784;623,404,625,540,953,1339,899,521,629,413,361,905;36;F
11813;623,615,625,629,624,611;58;M
11969;404,540,862,1339,521,600,668,205,430;37;F
12038;953;31;M
12295;623,1536,361,955,579,905,788,953;36;M
12387;870,625,520,430,623,404,788,953,521,668,1536,205,611,783,955;44;M
12546;842,862,1536;65;M
12610;623,615,899,629,416,600,413,611,905;27;F
12620;521,413,361,205,415,623,615,404,540,899,600,668,624,611,905;51;F
13072;623,615,625,629,624,611;36;F
13102;600,413,905;33;F
13189;520,788,953,955;26;M
13222;623,615,625,629,624,611;2;M
13344;1536,1640,611,783,623,404,842,625,788,1339,521,629,600,361,579;39;F
13833;623,870,899,668,615,629,413,611;58;M
13886;955,430,404,520,540,862,953,600,416,205;43;F
14081;1339,1536,415,600,625,521,361,955,520,788,862,953,1640,579,783;46;M
14316;361,1339,205,579,430,953,521,600,668,404,520,788,899,783;35;F
14344;623,404,625,668,413,905;44;F
14361;629,899,870,625,842,788,862,953,1339,361,783,955;35;F
14804;205,955,579,414,842,430,520,788,862,953,1339,521,600,624,1536;24;F
15331;415,905,579,1640,430,842,625,862,870,953,1339,1536,361,611,955;37;F
15378;842,625,862,953,1339,668,1536,430,404,905,579,955,1640,788,361;42;F
15588;629,521,1339,842,615,520,404,625,540,899,600,413,361,205,905;33;F
15591;1640,579,668,414,415,783,899,416,520,521,1339,404,205,625,624;76;F
15736;404,205,579;50;F
15775;361,579,862,520,623,430,625,788,870,899,668,624,413,205,611;27;F
15834;361,413,624,520,404,1339,430,788,842,862,953,668,1536,955,579;20;M
16021;668;47;M
16076;520,430,615,842,788,1339,521,953,416,600,955,404,361,205,783;59;F
16101;415,413,783,899,870,623,1640,205,624,416,600,521,862,404,579;39;F
16184;783,413,1536,870,625,623,404,540,1339,521,629,361,414,205,600;37;F
16288;540,625,629,416,615,404,862,521,600,413,361,1640,205,783,905;8;M
16314;668;23;M
16360;899,870,862,625,579,623,615,404,521,416,624,361,205,783,905;12;F
16376;615,520,842,625,540,668,361,783,862,1339,899,629,600,413,205;43;F
16443;668;21;M
16452;615,404,520,600,361,905;1;M
16488;623,404,788,870,1339,899,521,629,416,668,1536,361,205,783,955;41;F
16681;430,842,788,862,953,1536,361,955;15;M
16715;842,862,668;31;M
16963;862,600,416,1339,624,870,899;54;F
17002;862,600,668;38;F
17109;205,404,842,1640,783,520,430,788,953,361,955,579;24;M
17459;905,842,404,521,600,624,361,205;36;M
17511;615,415,1640,413,668,1339,414,404,521,600,205;44;F
17513;404,521,416,413,361,905;45;F
17538;899,668,624,611,579,361,955,540,404,615,625,629,600,1536,413;44;F
17779;615,404,842,625,540,521,629,600,413,205,611;38;F
17915;862,668,361,611;12;F
17936;668,361,611;6;F
18090;842,788,862,953,521,361,955;34;F
18510;404,1339,521,600,205,955;51;F
18735;623,862,953,1339,899,521,629,600,668,1536,413,361,205,611,955;35;F
18861;361,600,1339,404,625,788,521,629,668,205,783,579;36;M
18891;520,624,783,905,788,953,1339,1536,361,1640,955,579;32;F
18923;430,955,414,520,788,870,953,1640,1339,899,361,783,579;35;F
18967;404,520,625,862,870,899,521,600,416,413,205,611,783,579,905;47;F
19013;783,1640,600,899,623,870,668,579,404,540,1339,521,413,205,905;46;M
19019;615,404,520,625,870,899,521,600,416,413,1640,611,783,579,361;38;F
19122;842,862,1339,1536,361,955;32;F
19198;615,625,899,870,862;34;F
19300;1339,413,783,623,404,520,788,870,521,416,668,361,205,415,414;46;F
19375;625,624,520,1640,788,953,579,955,783;55;M
19436;899,521,629,600,416,624,361,205,579,905;48;F
19529;521,404,625,1536,361,611,905,430,788,870,953,899,1339,668,955;51;F
19722;955,361,1536,668,899,430,862;43;M
19779;430,862,953,416,668,1536,361,205,611,955;30;M
19837;905,361;37;F
19887;668;32;M
19901;414,540,623,615,842,624,361,520,862,1640,205,783,579,905,404;38;F
19975;842,862,600,783,404,788,953,1339,521,416,1536,361,205,611,955;48;M
20034;788,842,520,430,404,862,953,1339,955;46;F
20205;905,415,1640,361,1536,668,600,899,615,430,842,788,862,953,955;41;F
20314;415,623,540,600,579,205,521,404;36;M
20370;842,905,430,404,862,615,953,600,1536,361,205,955,579;40;M
20691;625,899,600,668,905;42;F
21123;521,625,788,629,205,430,842,862;38;F
21179;668;45;F
21194;953,629,668,1536,361,611,955,615,430,842,625,862,1339,899,413;32;F
21293;1640,520,404,1339,521,1536,579,905,430,615,862,842;44;M
21375;361,1640,205,955,430,788,870,953,1339,1536,783,579,842,862,899;36;F
21455;668,361,905,579,955,1536,600,899,953,870,862,788,625,842,430;35;M
21479;205,1640;43;F
21535;905,1339,600,520,842,788,862,1640,579;34;F
21600;788,842,1640,862,870,521,668,1536,205,404,953,1339,899,361,955;49;F
21716;862,1339,415,955,905,414,842,520,899,521,600,668,205,404,413;40;F
21737;1640,205,540,870,899,521,579,520,404,600;58;F
22259;615,1339,955,404,953,625,430,842,788,862,521,1536,413,205,611;42;F
22542;404,870,899,521,600,842,862;36;F
22558;430,862,521,600,361,415,520,788,953,624,1640,955;42;F
22584;205,1536,870,625,404,615,521;25;M
22694;842,404,615,788,862,953,899,521,600,668,413,361,955,579,415;37;F
23558;953,870,862,842,404,430,615,623,520,361,1640,783,955,579,788;56;F
23564;625,600,413,361,1640,955,579,623,615,404,520,788,205,862,521;32;F
23696;600,430,842,579,953,1339,361,788,1536,955;49;F
23845;953,668,579,415,205,361,521,788,520,404;74;F
24128;600,788,430,361,404;21;F
24343;540,1339,842,625,416,668,415,430,862,521,1536,1640,205,783,955;44;M
24554;404,615,623,520,788,862,1339,600,1536,413,361,205,579,905;15;F
24665;1536,783,955,625,520,623,404,414,579,870,788,521,361,1640,611;46;F
24726;1536,624,430,788,953,361,1640,520,783,579;26;F
24774;615,623,414,668,361,905;63;M
24786;625,520,404,615,623,413,414,361,629,899,668,905;57;F
24858;624,413,899,905,361,520,404,623,611,1640,668,629,870,615,625;50;F
24936;611,905,615,404,629,668,625;39;F
25000;624,600,870,788,623,615,404,520,625,629,668,413,361,1640,611;50;M
25092;579,870,788,600,611,414,415,624,899,625,520,615,404,668,361;84;F
25217;414,788,623,615,404,520,1339,899,521,416,624,413,361,205,611;30;F
25455;842,862,521,668;32;F
26328;414,404,625,842,870,899,624,361,1640,783,579,520,862,668,1536;28;F
26473;430,788,953,361,205,955;24;F
26499;870,625,623,615,629,611;52;F
27236;615,404,520,842,862,521,600,205;39;F
27472;623,953,899;32;F
28069;361,905;34;F
28115;862,870,1339,899,521,629,600,416,668,624,413,361,1640,205,905;42;F
28190;361,905,205,416,521;42;F
28208;783,414,404,842,788,862,953,521,600,1536,1640,205,955,579,415;44;F
28232;615,842,625,862,953,1339,629,600,668,413,361,1640,955,579,905;35;F
28244;862,579,905;40;M
28471;625,404,615,623,413,899,521,361,905,205;42;F
28503;629,579,404,520,788,1339,899,416,361,783,955,415,414;89;M
28601;430,615,623,414,905,955,361,783;42;F
28619;788,205,668,521,361,905;43;F
28628;615,600,611,361,905;39;F
28630;623,625,899,629,416,404,361;49;F
28650;1640,842,625,788,862,953,1536,361,955,413,415,414,1339,579,668;44;F
28699;361,905;42;F
28896;624,1339,361,521,600,205,540,404,520;58;F
28949;540,600,416,404,521,205;50;M
28964;623,615,404,361,783,955,905;35;F
29066;404,520,521,600,361,205;44;F
29099;430,520,1339;50;F
29171;788,404,870,1536,579,625,629,615,1339,521,361,205,611,415,905;44;F
29178;862,668;62;F
29249;870,521,624,361,905;43;F
29322;1536,600,629,521,862,788,625,842,623,615,953,1339,413,361,955;30;F
29394;361,1536,955;44;M
29500;625,842,520,430,623,862,870,1339,953,899,629,413,611;42;F
29555;520;53;M
29629;788,361,1640,579,520;21;M
29649;625,1640,623,629,615,870,899,361,404,540,521,413,205,579,905;45;F
29656;600,416,668,413,1640,579,905,205,361,624,899,870,520,415,414;49;F
29675;623,625,953,521,624,413,205,615,520,611;29;F
29731;540,953,521,205;35;M
29776;415,579,955,611,361,521,899,953,870,540,625,404,520,788,624;48;F
29835;842,862,668;38;M
29938;955,625,611,415,953,579,1640,899,870,520,788,624,783;46;F
30044;615,430,788,600,668,205,404,520,862,1536,413,361,783,955;73;F
30070;430,404,625,540,788,862,870,953,899,600,623,615,842,629,413;41;F
30095;625,540,953,668,624,413,955,579,783,361,416,600,788,404,905;43;F
30192;1536,624,1640,361,579,870,905;25;F
30347;955,611,629,1339,625,862;44;F
30349;623,579,1640,413,624,668,629,862,625,404,520,953,1339,783,955;38;F
30448;862,842,430;21;M
30566;623,404,521,600,413,205,611,905;40;M
30706;953,404,540,788,862,1339,899,521,600,1640,361;48;F
30878;625,600,413,205,623,404,520,842,788,862,953,521,624,1536,955;40;M
30905;623,615,520,842,625,862,629,521,600,668,624,413,1640,611,579;16;M
31036;615,842,862,870,953,1339,899,668,413,361,955;43;F
31206;404,842,600,361,205,783;36;F
31402;788,1536,783,905,430,404,842,862,953,600,1640,1339,361,955,415;45;M
31433;1640,404,668,783,579;59;M
31619;1640,430,520,870,600,205,783,579,905,404,625,1339,521,668,1536;19;F
31675;430,615,404,788,862,1339,521,600,668,361,1640,955,416,205,579;27;M
31812;600,415,783,629,1640,579,668,611,870,1339,899,521,205,404,414;65;F
31885;430,842,788,862,953,1339,361,783,955;38;F
31946;788,404;49;M
32250;430,625,955,404,788,953,521,624,1640,579,615,668,361,205,905;49;F
32260;905,1339,1640,842,361,955,899,862,520,430,788,870,953,624,1536;39;F
32276;623,953,413,361,955;34;M
32565;520,629,416,205,430,668,1339;39;F
32754;668;38;M
32769;788,1536,783;62;F
33022;521,413,629,1339,862,540,842,430,625,788,870,953,899,361,955;51;F
33060;625,1339,1640,624,668,600,520;48;F
33077;953,842,788,862;46;F
33086;430,1339,953,1536,905,404,520,842,788,862,521,600,361,205,955;37;F
33250;414,615,404,521,783,520,361,1640,205,579;52;M
33355;615,413,361,205,611,905;46;F
33426;430,404,953,521,600,205,955;29;M
33516;623,404,521,624,205,611;46;M
33522;521,416,361,579;46;M
33615;414,600,416,629,899,1339,520,615,623,404,625,870,521,205,579;48;M
33705;623,615,625,413,404;42;M
33933;862,629,615,414,955,625,788,899,521,600,361,413,205,404,905;46;F
34023;615,404,1339,521,668,361,205;44;F
34153;1339,899,361,624,668,629,870,625,404,520,521,205;48;F
34209;615,404,625,788,862,899,521,629,600,413,361,205,955,414,905;12;M
34328;615,404,625,788,862,899,521,629,600,413,361,205,955,905,414;4;F
34497;520;60;F
34651;905,520,404,540,521,416,600,205;60;F
34660;668,413,415,862,205,611;29;F
34835;623,615,520,842,862,899,521,600,1536,361,205,783,955,579,905;58;F
34914;623,520,625,870,1339,899,629,413,205,783;49;F
34966;205,1640,521,520,611,783;53;F
35306;905,520,540,600,413,1640,404,625,623,615,521,416,579,205,361;35;F
35470;430,404,842,862,953,1339,521,205,1536,955;37;F
35623;430,404,520,540,788,521,600,416,668,361,205,905;63;F
36079;842,953,521,205,783,955;42;F
36092;404,520,625,899,668,624,1640,579;32;F
36182;905,579,611,1536,870,862,842,430,623,615,625,788,668,361,955;30;F
36486;629,899,870,625,623,579,205,1640,600,521,404,615,788,361,905;44;F
36541;361,955,953,870,788,783,414,1640,579,520;48;F
36707;668,1339,788,414,520,521,624,205,579;60;F
36718;788,870,953,361,1640,783,579,520,624,1536,205;55;F
36766;404,625,540,521,600,413,205,905;44;F
36962;788,862,953,1339,361,1536,955,579;41;F
37053;521,205,579,430,404,520,1536,413;25;F
37116;953,1339,416,1536,413,361,404,520,540,788,521,600,205,955,415;41;F
37228;415,579,361,413,600,540,615,404,521,205;33;F
37239;1339,413,361,955,579,905,615,623,430,520,842,788,862,899,629;37;M
37328;629,783,615,404,625,1339,899,521,205,600,413,361,414;37;F
37365;430,520,788,953,1536,1640,414;46;M
37782;404,521,205;45;M
37797;540,579,415,870,788,842,404,862,953,899,1339,521,600,205,783;33;F
37824;953,404,521,416,668,783,415,414;76;F
38038;521,611,955;44;M
38161;520,953,1339;14;M
38188;870,540,623,404,1339,521,600,1640,611,361,413,624,625,953,668;41;F
38345;623,430,404,625,862,899,629,600,668,413;46;F
38565;615,404,361,1640,905,430,520,842,788,862,953,1339,600,955,579;47;F
38894;905,1640,205,413,629,521,899,870,625,520,615,404,842,862,600;43;M
38925;623,615,788,899,416,668,624,1536,413,611,414,905;41;F
38928;1640,862,520;47;M
38946;1640,600,521,520,862;47;F
39050;953,1339,521,600,1536,361,1640,205,955,579,905,430,842,625,862;43;F
39150;625,361;42;F
39330;899,905,862,615,623,870,953,1339,1536,783;30;F
39625;404,788,521;13;F
39791;430,404,625,870,600,788,521,668,413,205,415,629,615,611,623;51;M
39917;862,1339,611,668;43;F
39959;788,842,520,862,953,1339,521,600,1536,361,1640,205,783,955,579;39;F
40173;430,783,1536,899,953,870,788,540,404,520,361,1640,205,579,905;22;F
40439;404,625,788,870,899,1339,521,600,624,205,430,842,862,953,1536;35;F
40653;361,788,955,953,430,404,842,899,629,611,615,625,862,668,413;34;F
40742;842,615,430,862,953,1640,611,955,788,783;45;M
40783;540,416,413,361,404,788,521;49;F
40789;416,361,905;45;F
40842;430,862,842,668;43;M
40947;205,540,629,842,625,862,1339,899,668,413;36;F
40998;430,783,788;31;M
41080;953,1640,414,624,668,625,404,430,579,783,205,361,521,788,520;22;F
41119;842,788,1339,629,611,615,404,625,540,205,521,600,668,361;49;F
41137;430,1536,955,361,668,520,788,783;28;F
41199;955;29;F
41300;870,899,416,624,579;50;F
41480;615,611,668,413;38;F
41761;414,416,668,955,404,520,540,788,521,600,361,1640,205,783,579;62;F
41790;953,361,579,783,1536,624,404,520,788,1640,205;58;M
41999;623,615,404,625,540,899,521,600,668,413,205,611,579,905;53;F
42121;870,668,540,629,611,625,430,615,600,624,1640,579,520,1536,413;37;F
42138;625,953,668,1536,955,414,404,520,788,870,899,521,361,205;35;F
42225;404,905,611,899,953,615,430,788,862,870,1339,668,1536,783,361;36;F
42400;615,625,870,1339,899,521,629,668,413,611,905;41;F
42890;905,955,953,788,1339,361;58;F
42979;668,870,788,953,1339,955;17;F
43055;1536,788,520,1339,1640;60;F
43084;540,788,899,668,1640,205,905,430,842,862,953,600,1536,361,955;36;M
43306;413,1536,788,625,361,905,404,521,629,205,615,862,600;35;F
43474;615,625,540,788,1339,629,668,624,361,611,404,521,600,413,205;37;F
43505;615,520,953,899,361,611,783,955,579,905,404,540,521,600,205;39;F
43762;842,862,1339,1640,783,579,430,788,953,1536,955;25;M
43872;430,611,905,615,842,788,521,668,205,783,955;43;F
43964;413,1536,611,615,520,788,862,953,1339,668,624,361,783,955,579;38;M
44276;1339,415,615,623,862,953,413,205,611;43;F
44333;413,905,955,615,862,953,899,521,629,623,842,870,1339,600,361;28;M
45130;615,404,668,361,905;41;F
45136;953;28;M
45208;615,413,361,905;39;M
45218;430,540,862,1339,600,1536,404,788,521,624,361,1640,205,783,579;31;F
45265;361,905;40;F
45495;430,404,520,540,521,600,361,205,783;54;F
45822;625,870,953,1339,899,668,361,1640,955,430,842,788,862;35;F
45829;899,1339,870,788,540,625,520,404,629,668,361,1640,205,579,415;20;F
45863;953,1339,1536,955,430,361,205,905;44;F
45948;953,521,600,415,905,579,413,1536,668,1339,788,625,842,520,361;27;F
46653;870,899,415,414;61;M
46822;615,404,521,600,361,205;71;M
47059;625,521,783,579,1640,361,624,416,540,520,404,623;57;F
47808;600,611,623,521,870,668,205,404,788,905;44;F
47864;624,899,625,623,615,404,520,870,521,629,600,668,1536,205,579;41;F
48018;361,905;39;F
48164;905,899,1339,870,788,404,430,842,625,862,953,600,668,1536,955;38;F
48191;404,842,953,521,600,668,624;20;F
48192;430,842,862,1536;19;M
48248;842,899,668,414;65;F
48363;404,521,205,579;54;F
48422;862;44;F
48424;899,870,404,521,600,361,955,205;48;F
48434;905,404,862,953,521,842,205,1339,430,955,788,579,520,1640,783;39;F
48517;842,1536,783,955,862;32;M
48838;579,430,788,361,404,520,842,862,953,521,600,668,1536,205,955;58;F
49110;870;37;F
49549;520,629,611,579,615,404,625,540,1339,521,600,668,413,783,205;37;F
49615;623,615,842,540,870,1536,361,1640,414;36;M
49726;404,540,521,600,668,361,205;5;F
49815;842,862,668;5;M
50294;520,1339,416,624,413,611,415,414,404,788,600,1640,783;19;M
50424;899,521,615,430,404,842,625,788,862,953,629,668,413,611,955;3;M
50510;579,416,600,788,361,1536,624,521,404,205;48;M
50880;600,1339,870,520,899,415,414,668,624;69;F
50930;1339,668,415,953,600,955;63;F
51030;205,615,520,540,579,905,870,899,521,629,668,1536,361,611,414;41;F
51801;625,788,953,1339,416;35;M
51811;521,1640,862,205,783,579,416,668,520,361,430,842,788,955,953;17;M
51845;629,416,540,623,615,788,1339,521,668,404,625,600,413,361,205;37;M
51881;668,624,783,579,415,414,905,899,615,623;21;F
51894;615,842,899,668,905;29;M
51974;579,955,404,842,788,1640,783;38;F
51979;1536,205,415,842,788,668,361,905,862,870,953,1339,899,955,414;65;F
52122;611,615,404,625,416,629,205,623,870,1339,899,624,783,579,905;47;F
52236;625,870,629,413,899,668,361;49;F
52259;415,905,615,520,842,625,862,953,629,600,668,413,955,579,414;38;F
52537;1640,862,788,624,361,579,905,520,953,1339,521,416,955;28;F
52731;624,615,842,862;26;F
52832;842,788,862,600,1536,1640,955;48;M
53071;1536,430,579,205,600,404,842,788,862,953,1339,521,361,1640,955;33;M
53114;540,870,953,668,1536,361,1640,955,1339,414;40;F
53231;623,668,1536,625,520,842,788,862,870,953,1339,899,1640,783,579;67;F
53236;899,668,430,520,540,788,870,629,600,624,1536,413,1640,611,579;66;F
53503;520,788,862,600,624,1536,361,1640,783,955,579;68;F
53787;611,361,430,404,600;43;F
53959;783,955,579,1640,361,624,953,788,540,520,668,1536;17;M
53996;953,625,623,404,520,788,1339,521,629,416,361,783,955,415,414;77;F
54309;205,415,899,521,361,955,905,414,1536,600,862,404,788,540,842;44;F
54616;623,615,625,629,624,611;63;F
54832;625,629,414,615,623,668,205,540,579,600,521,404,413,361,905;45;F
54847;842,788,953,862,1339;61;M
55038;579,783,413,899,870,625,404,520,540,521,600,416,668,361,205;43;F
55222;1536,1640,783,955,905,668;53;F
55360;953,955,783,205,361,521,788;44;M
55369;1339,430,842,540,862,788,953,521,600,668,1536,361,205,955,905;37;F
55590;624,668,404,862,521,361,1640,783,905,520,625,540,600,205,579;33;F
55667;668,953,521,600,1536,361,205,905,430,404,842,788,862,955,579;45;F
55744;600;50;F
55792;205;72;M
55897;361,1536,1339,788,953,955;48;M
55962;842,862,668;5;M
56017;430,205,1339,629,600,955,579,414,623,615,625,788,862,953,413;35;F
56079;540,416,870,623,430,404,625,899,521,629,600,205,905;43;F
56124;615,624,361,623,404,842,625,540,862,521,600,416,668,205,905;9;F
56162;430,404,788,953,1339,899,521,600,668,624,1536,361,205,783,579;34;F
56177;953,1536,413,788,862,361,430,404,521,416,205,611,783,955,579;48;M
56197;870,623,404,842,625,540,788,862,521,629,600,416,361,205,905;12;F
56327;404,842,862,430,955,788,953;47;M
56332;404,788,953,668,361,955;47;M
56360;600,521,1339,404,205,955,430,788,953,624,361,1640,1536,783,579;37;M
56399;430,404,788,953,1339,899,521,600,668,624,1536,361,205,783,579;64;F
56554;404,520,953,521,205;47;F
56597;623,615,520,629,668,413,611,783,788,521;41;F
56627;899,205,623,404,520,625,1339,629,521,600,668,413,615,611,783;51;F
56667;415,905,430,842,862;33;M
56673;361,668,899,404,521,600;36;F
56722;430,842,862,415,905;32;F
56869;625,540,953,413,1339,842,205,521,1640,579,404,862,600,361,905;40;M
56906;416,430,404,842,788,862,870,953,1339,899,1536,361,205,955,783;54;F
56912;415,783,1640,361,413,1536,624,668,521,1339,870,404,615,623,899;36;F
56966;600,361,842,899,1339,404,788,862,870,953,521,416,955,205,783;86;F
57019;579,361,404,842,625,540,862,953,1339,521,600,413,1640,205,905;39;F
57063;205,579,783,870,788,615,430,404,625,1339,521,668,624,361,905;35;M
57082;361,905;44;F
57089;579,205,600,521,615,404;47;F
57139;404,862,899,521,629,600,668,361,205,579,905;33;F
57141;623,520,540,361,205,579;20;F
57192;623,615,668;22;F
57405;842,625,788,862,1339,899,629,413,205,783,955,615,600,361,905;37;F
57563;521,361,600,404,862,668,413;31;F
57570;1640,540,361,862,953,783,955,579,404,520,788,1339,521,600,205;45;F
57943;842,540,953,899,600,579,955,783,361,1536,668,623,520,862,521;33;M
58232;205,579,415,905,629,623,404,615,842,625,540,788,862,953,1339;35;F
58250;430,842,862,870,899,521,205,611;37;F
58284;1339,862,842,579,430,520,788,953,624,361,955;49;F
58347;1339,615,521,629,600,413,404,788,870,953,899,668,205,842,862;36;F
58561;629,415,1640,430,842,788,862,953,1339,1536,624,955;58;F
58603;842,788,862,953,1339,1536,205,955;33;F
58675;540,521,600,416,413,1640,611,404,862,953,1339,1536,361,783,955;39;F
58739;862,521,600,611,615,404,205,783;38;F
58934;404,625,540,862,899,600,416,413,361,205,955,905;41;F
58967;205,361,413,1536,668,600,629,521,1339,788,625,404,623,520,611;40;F
59017;623,615,520,413,361,205;41;F
59038;625,862,953,629;29;F
59086;413,1536,600,521,404,842,788,862,953,955;29;M
59109;520,615,788,870,953,600,624,414,1339,413,579,404,521,668,205;22;F
59267;404,842,788,862,953,521,600,1536,361,1640,205,579,955;40;F
59469;611,1536,899,623,625,788,870,521,629,668,624,520,361,205,579;47;F
59756;862,842;36;M
59757;788,953,521,361,1640,783,955,579,414;49;F
59966;905,579,540,430,404,842,788,862,953,1339,521,600,361,205,955;37;M
60225;842,430,1339,521,1536,611,205,668,600,615,404,625,540,629,413;9;F
60307;955,862,842,615,430,788,668,611;47;F
60331;404,1536;37;M
60431;842,862,668;3;F
60459;668,862,623,404,625,540,899,521,600,416,624,1640,579,414,520;53;F
60545;430,404,521,361,1640,955,1339,953,520,788,1536;27;F
60549;788,953,862,404,955;44;M
60565;404,521,600,205,955,905;47;M
60773;953,521,629,783,205,416,668,361,1640,955,579,611,415,1339,520;38;M
60882;788,953,955,905,404,842,361,862;37;F
60914;788,416,1536,414,404,842,899,521,205;61;F
60979;416,600,579,205,624,521,404;68;F
61083;788,899,361,1640,905,414,205,521,579,600,624,668,783,870,520;35;F
61113;615,361;68;M
61145;953,521,404,625,600,205,955;37;F
61162;430,842,788,862,1339,1536,361,783,955;52;F
61212;623,783,361,205,1339,1640,955;60;M
61327;361,905;46;M
61390;579,862,870,521,668,1640;51;F
61436;899,1339,430,623,615,520,953,842,625,788,862,361,413,955,579;43;F
61463;1640,579,625,899,629,416,955,611,361,1536,668,953,788,430,615;24;F
61502;1339;39;F
61579;1536,361,579,404,520,862,953,1640,783,205,521,1339,430,788,955;28;F
61885;788,953,404,520,1339,521,600,416,205;15;F
61981;623,625,842,404,862,521,600,1536,205,611,579;45;F
62094;615,404,520,788,625,205,521,668;52;F
62327;955,600,629,430,953,788,624,1536,361,611,625,413,905;47;M
62507;404,521,600,205;32;F
62522;430,788,862,953,521,416,1536,361,205,955;64;F
62818;430,404,842,862,521,600,1536,205;50;F
62955;668,870,629,413,615,430,404,520,625,540,521,600,624,205,611;49;F
63006;862;60;M
63288;404,953,899,521,600,668,1640,205,905;44;F
63548;629,1536,1640,611,783,579,953,870,788,404,623,520,625,521,205;45;F
63703;623,870,1640,899,668,905,579,414,955,783,1536,361,953,788,430;25;F
63772;205,1640,413,624,600,521,1339,625,520,579;30;M
63814;414,623,361,579,415,430,520,788,870,953,899,668,1640,783,955;52;F
63819;520,625,899,361,788,862,953,521,600,1536,1640,955,842,404,430;46;M
63952;414;33;F
64029;1339,629,668,625,870,899,905,623,404,521,600,413,361,205,611;35;F
64158;905,579,611,205,521,899,1339,623,615,404,625,540,629,600,413;36;F
64289;668;5;M
64319;668;2;M
64341;668;64;F
64343;414;37;F
64440;955,205,600,629,521,953,540,625,404,430,623,862,842,668;38;M
64583;404,520,625,521,600,1640,205,611,579,905,870,1339,899,668,624;33;F
64756;415,520,615,623,955,404,862,953,521,600,413,1640,205,579,788;41;M
64877;520,788,1640,361;21;M
65522;842,361,955;37;M
65762;416,788,953;52;M
65787;404,625,413,361,611;42;F
65989;1640,955,521,953,788,842,404,625,540,862,1339,600,1536,361,905;38;F
66324;520,788,953,1339,1536,521,361,1640,205,783,955;50;M
66800;783,870,668,361;21;F
66985;415,579,623,615,404,520,625,788,953,1339,668,624,361,205,611;54;F
66991;615,404,625;39;F
67021;783,361,416,600,404;69;F
67481;788,520,1339;48;F
67901;520,600,1536,361,611,783,788,842,404,615,955,905,430,862,1339;29;F
67941;404,615,1339,521,600,668,205,430,842,788,862,953,1536,361,955;38;F
68036;905,615,788,953,600,668,413,430,842,862,870,899,1536,361,955;39;F
68180;413,521,615,600,1536,579,205,1640,1339,788,520,404,842,862;35;M
68184;579,600,623,615,404,862,521,1640,205;36;M
68189;430,953,1536,520,1339,899,1640,955,361,668,870,404,788;48;F
68193;520,788,862,600,361,1640,783,955,579,415,905;51;M
68266;579,624,361;47;F
68285;520,870,1339,1536,600,521,899,615,404,842,862,1640,205,579;61;F
68316;625,416,413,361,905;37;F
68462;600,955,953,783,416,540,520,521,404,205;84;F
68491;955,953,521;85;F
68498;615,899,625,1536,361,404,788,862,205,905,579,955,629,600,1640;54;F
68561;361;59;F
68583;1536,579,783,899,788,842,870,520;78;F
68634;623,615,668,1536,205,783,579,905;32;M
68654;955,668,414,415,361,783,899,870,629;74;F
68659;361,842,540,899,629,611,579,404,520,521,600,668,624,413,205;44;F
68688;668,404,600,783,955,579,361,899,521,624,205;33;F
68689;629,953,788,520,623,413,361,955,870,899;26;F
68697;404,540,862,361,788,870,953,899,416,1536,783,955;45;F
68739;521,579,1339,600,668;39;F
68766;623,624,625,905,415,615,611;27;M
68795;404,842,862,953,1339,624,1536,413,361,1640,955;36;M
68844;1536,1339,842,862,788,520,404,953,361,955;47;F
68851;842,862,955,1640,430,404,520,788,953,361,205,783,579;23;M
68875;953,955,579,404,788,600,361;22;M
68900;404,521,629,600,416,1640,205,783,415,905;71;F
69003;404,862,600,579;41;F
69025;205,870,404,625,788,1339,521,416,579;21;F
69115;404,521,600,205;70;F
69369;623,870,404,625,521,600,1640,579,842,788,862,953,361,205,783;37;F
69429;1536,783,414,623,430,404,842,625,579,953,521,600,1640,205;40;M
69452;1640,862,540,842,520,430,404,953,1536,361,955,579,905;37;F
69495;521,899,1339,870,520,953,1536,361,788,430,404,955;85;F
69501;1536,623,615,520,842,625,540,862,899,521,629,600,413,1640,205;6;M
69538;579,1640,413,1536,668,600,629,521,862,540,625,842,520,404,615;4;M
69573;615,623,404,520,842,625,862,899,629,600,668,624,1536,1640,579;44;F
69599;600,521,404,205;72;M
69647;870,540,404,520,521,600,624,1640,205,579;25;F
69765;520,623,615,625,629,611;69;M
69784;623,413,361,905,205,540,404,521,600;62;M
69810;600,668,521,361,1536,953,842,579,955,520,788,862;43;M
70146;579,955,783,205,1640,361,600,1339,953,788,540,842,623,520,521;32;F
70309;361,205,415,905,521,404;71;M
70397;905,413,624,668,600,521,899,870,625,842,404,615,623,862,579;43;M
70402;404,842,540,788,862,521,600,361,205,579,905;9;F
70405;404,862,899,521,629,600,668,361,205,579,905;44;M
70439;870,899,521,600,668,361,205,579,615,404,520,953,1339,611,955;36;F
70485;862;38;F
70526;788,611,579,205,623,404,870,899,521,629,600,668,624,413,361;43;F
70541;404,540,416,361,905;9;F
70592;1339,899,521,205,413,615,842,625,862,414;36;F
70597;905,361;48;M
70627;361,905;11;M
70629;870,1536,361,783,623,842,625,862,1339,899,668,624,413,611,955;41;F
70646;404,521,579,862,600,668,361,905;44;F
70791;623,615,625,629,624,611;64;F
70867;361,623,404,205,668,600,629,521,625,615,624,413,611,905;40;F
70968;905,955,783,1640,361,416,899,953,788,870,414;56;F
70979;625,899,521,361,205,579,905;53;F
71195;520,615,625,521,629,783,579,905,413,899,870,788,404,1339,205;36;M
71224;205,414;33;F
71253;625,1339,899,521,600,1536,205,783,430,842,788,862,953,361,955;45;F
71297;842,615,1339,600,416,624,1640,955,788,404,520,521,361,205,579;32;F
71312;615,625,540,788,629,600,955,905,404,1339,842,862,521,1536,205;62;M
71535;899,416,361,783,579,623,404,625,521,629,600,668,413,205,611;48;F
71591;624;57;F
71601;540,905;38;F
71626;1536,870,788,540,842,862,953,1640,955,520,430,1339,361,579,783;61;F
71794;414,623,404,842,862,953,1339,600,668,1536,413,361,611,579,615;35;M
72178;415,414,413,668,404,520,625,870,600,361,905,899,521,624,205;48;M
72252;623,615,625,629,624,611;85;F
72341;540,416,361,1640,842,521,953,1536,205,955,579,905,414,404,1339;46;F
72342;623,615,625,629,624,611;97;M
72368;623,615,629,625,624,611;69;M
72408;788,953,955,1536,579;56;F
72794;600,361,623,615,404,625,521,629,416,668,413,205,611,415,905;51;M
72947;611,205,1640,413,521,520,615,623,624;26;M
73053;783,668,1339,953,430,521,623,615,520,788,600,413,361,1640,579;34;F
73224;416,629,899,862,788,625,520,615,623,600,955,404,953,521,205;37;M
73336;668,623,540,783,953,788,625,520,404,521,600,416,361,205,955;31;F
73527;404,625,579;43;M
73534;414,415,611,1640,413,625,615,788,870,899,629,416,624,205,579;47;F
73545;520,416,361,862,955,600,430,842,788,668,624,1536,783;59;M
73617;623,625,862,1339,629,600,1536,205,611,404,521,668,413,955;39;M
73692;788,953,899,521,600,1640,579,623,615,404,361,413,611,783,955;44;F
73846;520,404,788,899,521,1536,361,1640,205,579,905,414;25;F
73975;783,404,540,521,600,413,361,205,579,905,414;69;F
74318;615,953,1339,416,361,205,955,579,905,842,788,862;48;F
74555;520;32;F
74767;623,842,625,862,870,899,629,611;31;F
74801;668;46;F
75072;415,404,540,521,629,905,579,361,600,788,623,625,615,1339,416;43;M
75076;1339,521,615,520,862,842,625,899,668;40;F
75204;404,625,540,521,629,600,668,205;13;M
75296;842,862,404,521,600,205,783;42;F
75402;404,520,842,862,521,600,205;6;F
75605;415,414,430,615,788,870,953,1339,899,668,1536,1640,783,955,579;49;F
75997;955,579,1640,361,953,404,430;22;M
76285;521,205,415,905;71;F
76308;783,1640,361,1536,668,862,788,625,623,899,953;43;F
76319;788,1339,624,1640,955;42;F
76401;623,615,540,788,600,416,668,413,1640,205,783,404,520,361,905;36;F
76536;404,540,205;24;F
76574;668,624,413,361,611,414;56;F
76596;623,404,540,668,413,1640,611,615,899,521,361,205,905;49;F
76680;953;23;M
76859;520,361;21;F
76978;953,905,788,361,955;50;M
77613;615,205,783,579,415,842,520,625,870,1339,668,624,361,611,955;9;F
77660;668,205,1536,430,404,625,788,953,521,579,905;54;M
77674;521,205,361,579;60;F
77761;1339,521,1640,415,579,955,862,788,842,404,430;45;M
77794;404,625,600,579;31;F
77930;430,788,521,361,1640,205,579,414;73;F
78055;623,842,862,953,668,414;40;M
78090;1339,870,361,615,404,625,899,521,629,600,668,413,205,611,579;37;M
78185;1339,205,414;10;M
78388;615,625,521,600,668,413,361,205,611,579;34;F
78432;404,862,870,953,899,361,205,783,955;65;F
78495;520,842,788,862,1339,899,1536,955;53;F
78586;788,862,361,905,955;48;M
78713;430,615,361,404,842,625,862,953,521,600,1536,1640,205,783,579;6;F
78808;668;40;M
78870;668;9;M
78892;668;40;F
78966;579,361,788,1640,905,520;22;M
79400;668;48;M
79426;668;7;F
79456;955,953,862,600,579,416,783;48;F
79539;623,615,625,629,624,611;96;F
79859;842,788,862,953,1339,1536,361,1640,783,955,579,430,404,600,624;28;M
80095;668;13;M
80231;430,783,955,905;54;M
80338;953,862,788,842,955;39;M
80373;615,1339,600,579,783;64;M
80382;788,668;42;F
80515;404,520,625,540,862,1339,899,521,600,668,413,205,955,579;42;F
80538;862,521,783,905,404,540,788,870,953,1339,899,600,416,361,414;54;F
80832;521,361,205,615,404,600,413,905;44;F
80884;1640,629,540,625,870,521,600,413,361,611,520,404,615,623,205;42;F
80925;361,953,1536,955;33;F
81013;430,615,668,413,905,579,1640,361,629,953,862,788,625,842,623;38;F
81020;623,404,520,625,870,1339,899,629,668,624,1536,413,1640,611,579;22;F
81047;625,521,668,404,205;26;M
81159;430,862,1339,1536,611,955,905,623,615,788,953,629,668,413,415;65;M
81163;205,430;61;M
81344;624,629,521,953,623,899,540,625,862,783,615,404,1339,668,413;39;F
81374;623,404,625,899,521,629,600,668,361,205,611,413,615;43;F
81501;404,540,521,600,668,205,579;40;F
81506;205,783,955,579,520,862,953,600;31;F
81527;404,788,521,600,205,1640,579;39;F
81573;579,615,540,1536,611,842,862,521,600,205,905,404,788,953,955;64;M
81594;404,899,668,783,579,870;53;M
81650;415,624,430,870,953,955,1640,361,521,905,404,520,788,1339,205;18;M
81815;416,625,205,1640,600,521,1339,862,788,842;38;F
82451;521,600,668,413,205,615,899,629,361,905;48;F
82464;623,615,625,899,521,629,600,668,413,361,205,611,905;51;M
82510;625,615,413,579;19;M
82601;615,404,625,899,521,600,668,413,361,205,611,905;11;F
82633;205,521,404;64;F
82684;623,615,404,625,899,521,600,668,413,361,205,611,905;13;M
82777;623,615,404,625,899,521,629,600,668,413,361,205,611,905;21;M
82999;540,870,899,600,413,361,205,579,623,615,625,521,629,624,611;50;M
83063;615,899,842,862,413;35;F
83184;788;32;F
83224;416,623,615,668,361,404,870,899,521,600,413,205,611,415,414;61;F
83537;905,404,1536,1640,783,414;75;F
84159;842,520,404,615,623,953,1339,521,361,783;36;M
84294;788;24;F
84442;623,404,842,625,540,862,899,521,629,416,668,413,205,905,414;12;F
84455;415,414,413,1640,611,579,905,205,668,629,521,1339,404,615,623;35;F
84617;624,404,623,842,788,862,953,1339,521,600,413,361,1640,205,955;35;F
84649;521,579,1640,404,625,611,905,205,361,413,668,870,600,540,623;41;F
84656;899,629,668,416,361,783,905,414,404,625,870,521,600,413,205;31;F
84696;521,579,1640,611,205,413,668,870,600,540,623,404,625,361,905;41;M
84730;625,615,623,404,540,1339,521,600,416,413,361,205,955,415,414;66;F
84962;540,862,1339,899,521,953,955,413,905,205,668,600,788,404,361;43;F
85116;579,413,624,416,600,430,404,520,788,953,521,361,1640,205,955;19;M
85163;615,404,625,862,1339,899,600,416,668,413,361,205,611,579,905;34;M
85181;430,842,953,1536,955;20;M
85192;361,205,905,430,404,842,862,953,1536,1640,955,579;55;F
85345;414,955,611,1339,953,862,788,842;41;M
85432;404,520,579;42;F
85439;404,579,1640,520;42;M
85689;1536,521,615,862,788,404,205,611,783,430,870,953,1339,361,955;46;F
85746;430,404,788,862,955,415,414,520,953,521,1536,205,611,615,600;42;M
86509;615,205,788,862,899,521,600,842,430,404,953,1536,413,361,955;43;F
86596;520,521,624,205;53;M
86861;430,404,905,579,955,1640,1536,520,842,788,862,953,1339,361,783;27;F
86979;415,361;44;M
87116;361,579,404,521,600,416,205;60;M
87391;579,404,520,361;64;F
87433;579,1339,404,540,521,600,416,205;57;F
87531;611,540,1339,521,623,842,629,624,205,404,625,862,899,600,668;31;F
87537;540,521,629,413,361,205,625,788;33;F
87649;905,414,615,430,623,540,953,416,413;73;F
87738;899,615,955,1536,668,953,788,842,430,540,404,521,600,416,205;46;F
87926;205,579,413,520,404,540,521,600;42;F
88032;404,520,870,624,413,205,611;42;F
88044;625,870,624,1536,955,788,953,1339,1640,783,579,430,521,361,205;59;F
88106;520,430,1339,205;30;M
88122;623,404,600,1536,413,430,842,862,953,1339,521,668,361,205,955;40;F
88123;521,1640,205;59;M
88211;404,520,625,540,521,600,1536,579;12;M
88350;404,520,521,600,361,611,615,416;45;F
88361;623,520,625,600,413,611,404,521,205;43;M
88410;205,521,520,615,625,579,611,1640,361,1339,404,623;27;M
88470;623,520,1339,521,600,624,361,1640,205,783,955,579,953,668,1536;46;F
88490;842,430,862,953,624,1536,414;33;M
88519;899,521,1536;34;M
88644;430,404,520,842,862,953,1339,521,600,1536,361,205,611,955;14;M
88745;1640,611,579,788,862,953,1339,361,430,520,842,955,624,1536;33;M
88767;668;44;F
88800;404,899,521,600,416,624,205;54;F
88811;668;5;F
88857;600,668,361,905,205,416,404;48;M
88889;600,1536,413,905,361,1640,625,404,520,540,862,521,205,955,579;41;F
88911;668;13;F
88976;668;15;M
89027;905,404,862,521,600,416,361,205,540,1640,579,615,668,611,415;56;F
89153;870,615,623,404,520,625,540,521,600,624,413,361,611,579,905;10;F
89178;623,430,404,842,625,788,899,629;55;M
89188;520,625,540,870,899,415,905,862,842,430,416,404,521,600,205;43;M
89198;668;39;F
89223;629,521,625,404,615,783,905;45;F
89272;788,430,404,842,625,862,953,521,600,1536,361,1640,205,783,579;2;M
89306;430,629,623,625,1640,579,404,842,862,521,600,1536,205;5;F
89458;668;40;M
89494;1536,361,205,579,623,625,953,862,788,842,430,955,905,600,521;33;M
89553;905,361,788,579,1640,413,205,600,521,862,404,955,623,615,520;5;F
89585;668;82;F
89669;842,430,862,1339;27;F
89692;668;18;M
89695;862,1640,415,205,623,615,404,520,788,953,521,361,955,579,905;7;M
89790;668;16;F
89860;404,520,788,870,521,579,415,624,205;24;F
89891;668;15;F
89937;668;9;F
89952;842,788,862,953;42;M
90132;629,600,905,899,870,623,615,404,521,668,413,361,205,611;33;F
90210;615,520,842,540,788,1640,623,579,404,862,521,600,413,205,905;38;F
90311;955,413,414;42;F
90347;404,788,953,521,600,624,361;58;F
90354;1536,404,905,842,540,1339,629,600,205,783,668,899,625,862,521;42;F
90446;862,783,1339,430,611,955,788,404,615,953,521,413,361,205,905;40;F
90725;625,1536,361,1640,205,783,404,842,540,862,579,905,520,788,1339;44;F
91075;953,520,404,842,625,862,870,899,521,600;41;F
91264;404,842,625,953,1339,361,205,955,862,624,1536;42;F
91425;521;17;F
91520;205,905,404,842,862,521,361,1640,783,579,430,788,953,1536,955;33;M
91539;430,842,788,862,953,1536,955;35;M
91566;521,579,404,520,870,899,668,205;50;F
91668;668,1640,600,1339,615,404,788,955,953;44;M
91683;430,404,788,870,899,521,629,668,624,1536,413,361,205,579;31;F
91691;1339,668,624,361,1640,205,783,955,579;33;M
91729;788,1339,1536,361;64;M
91849;623,404,870,899,521,629,668,624,205;49;F
91851;414,520,625,788,1640,579,415,205,600,629,404,521,668,624,361;45;F
92168;629,600,416,668,361,205,611,783,579,415,905,414,404,899,521;45;M
92241;623,615,625,629,624,611;4;F
92390;623,615,625,629,624,611;42;M
92656;788,629,625,404,520,521,600,668,624,361,1640,205,579,415,414;13;M
92817;205,788,625,404,520,521,629,600,668,624,361,1640,579,415,414;11;M
92834;623,520,625,862,870,899,629,600,413,1640,611,414;33;F
92950;624,404,520,625,788,521,629,600,668,361,205,1640,579,415,414;46;M
93136;361,842,625,862,870,1339,899,1536,413;33;F
93198;413,783,404,361,430,905,579,1536,953,870,788,842,520,899,1339;23;F
93543;404;51;F
93616;623,404,842,625,862,899,521,629,600,668,413,205,905;49;F
93639;905,955,205,1536,953,862,842;37;M
94038;842,788,205,955,615,600,413,1640,404,520,540,361,783,579,905;40;F
94114;404,540,788,953,1640,905,520,862,870,1339,899,600,1536,361,783;30;F
94219;1339,413,205,783,905,361,623,615,788,870,521,416,1640,611,579;54;F
94403;842,623,625,540,788,1339,899,629,668,624,413,361,905,520,611;46;F
94551;625,862,1339,899,600,413,205,611,415,955,579,414;39;F
94738;953,862,1339,600,416,783,520,788,521,1536,1640,205,955,414;65;F
95034;905,404,520,540,521,600,205;58;F
95063;1339,870,624;58;F
95152;600,783,579,1640,361,624,1339,520;38;F
95253;623,788,870,899,624,361,783,905,520,862,953,1339,955;54;F
95260;404,521,600,416,205,611,955,414;70;M
95302;520,788,870,668,624,361,1640;48;M
95442;521,430,416,205;42;M
95496;623,615,430,404,842,540,862,953,1339,899,521,600,668,361,205;33;F
95533;600,629,1339,870,862,540,842,623,615,625,899,521,668,413,611;31;F
95613;870,611,414,520,862,668,1536,404,788,1339,521,361,1640,205,783;63;M
95808;623,520,870,1339,899,629,668,624,361,955,783;52;F
95833;415,905,205,1536,624,600,521,615,520,788,953,361,1640,955,579;51;M
95951;629,1536,413,404,625,540,521,600,205,579;40;M
96262;842,862,953,1339,521,600,1536,361,1640,205,579,520,905,788,955;19;M
96272;842,600,1536,361,205,783,404,520,788,1640,579;42;M
96536;579,205,600,521,540,625,404,413,1536,629;9;F
96674;579,205,600,521,540,625,404,629,1536,413;7;M
96700;430,520,862,953,955;20;M
96827;579,205,600,521,540,625,404,413,1536,629;38;F
96873;416;64;F
97123;899,521,600,413,1640,611,520,783,579;43;F
97518;579,415,414,899,611,1339,953,1640,361,629,623,625,870,668,205;44;F
97604;862,953,1339,899,521,600,1536,361,205,955;61;F
97632;416,404,788,521,361;16;F
97819;404,842,600,361;45;F
98209;623,668,615,404,625,899,521,629,600,413,361,205,905;29;F
98411;629,862,623,615,625,788,899,521,600,416,413,361,668,205,905;47;F
99040;404,520,788,600,361,1640,205,579;26;F
99161;404,870,899,521,600,416,361,205;64;F
99211;361;39;F
99564;623,404,540,899,521,600,361,205,611;42;F
99646;600,668,611,414,905,415,579,955,361,1536,629,1339,953,615,430;48;M
99679;955,1536,1339,404,430,842,788,862,521,361,205;65;F
99860;668,953,899,870;35;M
100142;521,600,205,783;37;F
100152;623,404,520,625,540,870,600,668,413,205,579,415,414;45;F
100603;623,520,625,870,624,1640,788,953,1339,1536,361,955,579;30;M
100759;404,625,540,521,629,600,413,361,205,611;41;M
100924;430,1536,862;56;M
101193;404,842,862,870,953,521,600,955,1536,205;38;M
101255;615,520,416,1536;32;M
101324;1536,668,520,623,404,870,899,521,629,413,361,1640,205,611,579;26;F
101376;404,521,205,414;46;F
101450;862,842;38;F
101488;413,600,629,520,615,404,1640,611,579,415,623;47;M
101552;404,521,579,1640,520;33;F
101869;842,862;50;F
101960;414,540,520,430,788,953,1339,899,600,668,624,1536,1640,955,579;74;F
101977;430,404,862,905;27;M
101978;404,430,788,953,361,955;18;M
102017;615,404,625,540,521,629,600,413,361,1640,205;41;F
102056;615,625,668,361,1640,611,783,579;35;F
102276;668;44;F
102397;404,870,413,361;50;F
102569;404,579;69;F
102626;404,600;65;F
102694;862,205,623,629,416,414,415,905,361,600,521,788,842,404,430;38;M
103006;414,905,415,413,870,540,623,615,625,629,624,611;49;F
103127;404,788,953,521,416,1640,205,415,520,361,905;65;M
103154;430,870,953,899,521,1536,955,415,520,788,668,361,1640,205,579;26;F
103290;430,520,842,788,953,1339,521,1536,361,1640,205,955;43;F
103301;521,600,668,579,205,783,955,414,430,404,788,953,1339;44;F
103389;624,1536;30;M
103516;625,540,579;37;F
103699;404,625,1339,899,521,1536,955;51;F
103845;520,600,416,361,1640,205,579,415,905;68;F
103862;842,862;39;M
103941;600,361,579,520;32;F
104129;430,404,788,862,953,1339,521,1536,205,955;63;M
104138;625,629,668,415,905,414,404,205,521,361;39;F
104255;404,540,870,579,623,615,520,521,600,205;39;F
104466;788,953,955,600;49;M
104929;540,623,615,404,842,862,521,600,668,205,579;47;F
105071;625,1536,361,611,955,615,404,870,1339,899,629,413,1640,205,783;52;F
105297;955,842,788;59;F
105303;623,668,870,899,521,624,415,414,783,205,1640,404,600,579;34;F
105549;520,361,579,905,414;20;F
105654;579,205,1640,870,625,404,520,521,629,416,1536,783;64;F
105732;788,899,600,611,361,615,540,953,1339,668,955,404,521,205;71;M
105739;404,520,788,870,953,205;29;F
105769;905,783,668,788,540,404,521,416,361;56;F
105938;955,624;28;F
106018;625,600,615,540,788,899,629,668,413,1640,783,611,404,579,430;41;F
106105;404,625,870,899,521,629,600,668,624,361,205,579,905;39;F
106128;430,870,862,1536;29;F
106289;540,668,413,625,404,520,899,600,416,624,361,1640,205,611,579;52;F
106305;540,600,668,624,416,625,520,615,361,611,414,404,1640,205,579;58;M
106318;404,623,625,540,788,668,1640,611,415,520,870,899,624,783,579;52;F
106322;615,404,899,521,1536,416,668,361,955;58;M
106365;842,404,430,623,953,629,361,955,615,870,1339,899,668,413,611;40;F
106417;624,629,788,540,404,623,615,520,625,870,899,521,416,668,361;45;F
106551;953,788,842,430,404,862,521,600,1536,205;46;M
106824;521,600,205,955,953,520,404,788,361,1640,579;18;M
106984;430,404,788,521,668,205;52;F
107055;624,1640,579,415,520,625,788,870,953,1339,629,668,1536,361,955;41;F
107064;361,624,521,404,600,520,205;26;M
107082;1536,414;40;M
107144;668;38;M
107181;955,615,430,404,625,540,788,629,600,668,413,1640,611,783,579;40;M
107377;870,624,1536,842,1339,361,955,430,788,862,953;32;F
107434;415,414,955,600,1339,953,788,540,615,404,521,205,579;23;F
107442;430,520,788,953,361,579;16;M
107471;668,579,905,953,361,1640,783,430,842,788,862,899,1536,955;37;F
107575;540,600,416,415,414,430,788,1339,668,624,1536;30;F
107611;579,205,1640,521,1339,404,520,788,361;17;M
107629;842,521,615,430,404,625,540,788,629,600,668,413,1640,611,579;13;M
107773;361,579,414,624,629,953,623,404,625,862,600,668,1536,413,955;41;M
107792;430,842,1640,955,361,953,788;45;F
107812;668,1640,205,783,579,615,625,1339,521,600,416,1536,413,361,905;38;M
107952;430;74;M
107957;430,842,788,862,953,668,1536,361,1640,205,783,955,579,905;38;M
107972;623,862,615,430,404,625,540,788,899,629,600,413,1640,611,579;9;F
108191;404,788;53;F
108278;783,579,414,624,416,404,520,521,600,415;57;F
108475;1536,205,1640,862,579,955,668,953,788,625,520,430;15;M
108593;404,842,862,953,521,600,361,205;33;F
108659;623,430,520,842,788,862,870,953,1339,899,1536,611,783,955,579;66;F
108893;615,404,520,625,540,862,521,600,416,413,361,205,905;39;F
108919;629,899,404,623,615,430,520,788,862,1339,668,1536,413,955,579;29;M
109268;623,404,1339,899,600,668,1536,413,361,905,615,870,629,205,611;24;F
109287;624,521,899,1339,862,615,430,520,788,870,953,413,361,783,955;47;F
109366;430,520,953,361,955;26;F
109690;953,788,842,520,615,404,862,1339,899,521,600,668,1536,205,414;20;F
110008;430,862,521,668,361,205,955;15;F
110064;624,668,521,899,540,520,788,862,870,953,1339,629,600,361,205;28;F
110103;905,579,955,205,361,953,870,625,623,430,520,842,788,862,629;39;F
110116;404,579;37;F
110233;540,862,521,600,788,842,615,430,404,953,1536,413,361,205,955;46;M
110278;625,1640,783,579;65;F
110398;623,625,668,520,540,600,415,404,521,416,361,1640,205,579,905;50;F
110487;623,625,540,629,668,414;40;M
110520;668,520,624;69;F
110816;788,1339,783,842,862,361;38;M
110874;430,404,788,521,668,205;53;M
110974;870,899,361,615,404,520,625,521,629,600,624,668,413,205,611;33;F
111050;1640,623,579,625,899,624,668,611;62;F
111064;783,416,540,521,600,905;44;M
111118;579,520,870,668,361,414;64;F
111325;415,414,905,623,404,520,540,862,788,361,521,600,416,1536,205;47;F
111407;404,862;47;M
111670;430,788,953,955;19;M
111885;788,783,414,520,404,540,521,600,416,361,1640,205,415,579,905;80;F
111957;668;26;M
112106;404,521,205;47;F
112107;404,430,842;63;M
112145;625,1339,521,624,413,361,205,611,579;32;M
112289;430,404,540,521,600,205;41;M
112586;430;61;M
112954;600,205,1640,520,1339,1536,404;24;F
113158;615,520,870,899,361,905;41;M
113338;615,404,540,870,899,521,600,668,361,205;35;F
113348;521,862,416,540,668,520,430,404,625,624,1536,205,579,415,414;58;F
113361;404,625,521,600,361,205,905;33;F
113419;404,521,416,205,783,905;75;F
113734;623,615,404,624,600,415,414,520,1339,625,870,899,1536,1640,579;53;F
113764;953,788,899,1536,361,955;63;F
113836;579,842,361,414,430,862,521,1536,205,905,404,788,953,668,955;23;M
113986;788,629,540,625,205,413,668,600,521,1339,862,842,623,615,404;40;F
114044;615,629,611;51;M
114204;788,905,361,404,521,205,862,600,668,1640,955,625,842;57;M
114469;625,788,870,413,361,611,955,905,414,521,862,842,404,430,615;39;F
114489;615,404,625,540,862,668,205,611;40;F
114522;361,521,842,404,430,623,520,862,870,953,899,629,624,205,955;66;F
114555;783,361,955,611,205,413,521,953,862,788,625,842,404,430,615;78;F
114631;1536,668,600,521,899,870,540,625,615,430,842,788,862,953,1339;34;F
114827;629,521,842,404,623,615,905,414,520,625,788,668,600,415,955;29;F
114877;361,1640,615,625,413,404,520,521,600,205,579;40;F
114888;540,870,1339,899,521,629,600,416,668,1536,413,361,1640,205,955;44;M
114934;600,430,842,540,953,521,1640,579,404,205,955;22;F
115024;783,842,361,615,404,430,625,788,862,953,521,413,205,611,955;78;M
115255;623,615,625,629,624,205;48;F
115281;625,862,1339,1536,361,615,404,520,521,600,413,1640,205,611,579;42;M
115359;361,1536,615,430,955,205,600,521,788,404,842,862,953,611,783;37;F
115463;629,623,404,615,521,668,413,905,205;59;M
115517;1339,862,615,404,520,521,629,600,413,361,1640,205,611,783,579;7;F
115579;404,520,625,521,600,416,361,205,783,415,905,414;47;F
115630;404,623,615,414,905,579,955,624,899,953,862,788,668,361,783;36;F
115733;899,624,870,623,615,625,629,611;36;F
115763;623,430,520,788,953,955;20;M
115771;862,625,842,615,404,520,1339,521,629,600,413,1640,205,611,579;7;F
115893;842,521,788,862,404,615,520,625,1339,629,600,413,1640,205,579;11;F